//オブジェクト一覧
const formObj = document.querySelector(".form-contact");
const elemName = document.querySelector(".name");
const elemMail = document.querySelector(".mail");
const elemTel = document.querySelector(".tel");
const elemComment = document.querySelector(".comment");

//submitイベントを設定
formObj.addEventListener("submit", function (e) {
  //お名前欄に入力された文字列を取得して変数に格納する
  const nameInput = elemName.value;
  //E-Mail欄に入力された文字列を取得して変数に格納する
  const mailInput = elemMail.value;
  //メールアドレスの正規表現パターンを変数に格納する
  const regExpMail = /^[A-Za-z0-9]{1}[A-Za-z0-9_.-]*@{1}[A-Za-z0-9_.-]+.[A-Za-z0-9]+$/;
  //TEL欄に入力された文字列を取得して変数に格納する
  const telInput = elemTel.value;
  //電話番号（ハイフンあり）の正規表現パターンを変数に格納する
  const regExpTel = /\d{2,4}-\d{2,4}-\d{4}/;
  //ご要望・ご質問など欄に入力された文字列を取得して変数に格納する
  const commentInput = elemComment.value;
  //if文でお名前欄の空欄チェック
  if (nameInput == "") {
    alert("お名前を入力して下さい。");
    e.preventDefault();//送信をキャンセルする
  } //ここからメールアドレスのチェック 
  else if (!regExpMail.test(mailInput)) {
    //ここに入力された文字列が正しいメールアドレスではなかった場合の処理を記述する
    alert("メールアドレスを正確に入力して下さい。");
    e.preventDefault();
    //ここから電話番号のチェック
  } else if (!regExpTel.test(telInput)) {
    alert("電話番号をハイフンありで正確に入力して下さい。");
    e.preventDefault();
    //ここからご要望・ご質問などのチェック
  } else if (commentInput == "") {
    alert("お問い合わせ内容を入力して下さい。");
    e.preventDefault();
  }
})